<?php
namespace ElementorPro\Modules\Sticky;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Widget_Base;
use ElementorPro\Base\Module_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Module extends Module_Base {

	private $is_prior_to_250;

	public function __construct() {
		parent::__construct();

		$this->is_prior_to_250 = version_compare( ELEMENTOR_VERSION, '2.5.0', '<' );

		$this->add_actions();
	}

	public function get_name() {
		return 'sticky';
	}

	public function register_controls( Controls_Stack $element ) {
		if ( $this->is_prior_to_250 ) {
			$element->start_controls_section(
				'section_scrolling_effect',
				[
					'label' => __( 'Scrolling Effect', 'elementor-pro' ),
					'tab' => Controls_Manager::TAB_ADVANCED,
				]
			);
		}

		$element->add_control(
			'sticky',
			[
				'label' => __( 'Sticky', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'None', 'elementor-pro' ),
					'top' => __( 'Top', 'elementor-pro' ),
					'bottom' => __( 'Bottom', 'elementor-pro' ),
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'sticky_on',
			[
				'label' => __( 'Sticky On', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => 'true',
				'default' => [ 'desktop', 'tablet', 'mobile' ],
				'options' => [
					'desktop' => __( 'Desktop', 'elementor-pro' ),
					'tablet' => __( 'Tablet', 'elementor-pro' ),
					'mobile' => __( 'Mobile', 'elementor-pro' ),
				],
				'condition' => [
					'sticky!' => '',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'sticky_offset',
			[
				'label' => __( 'Offset', 'elementor-pro' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'max' => 500,
				'required' => true,
				'condition' => [
					'sticky!' => '',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'sticky_effects_offset',
			[
				'label' => __( 'Effects Offset', 'elementor-pro' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'max' => 1000,
				'required' => true,
				'condition' => [
					'sticky!' => '',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		if ( $element instanceof Widget_Base ) {
			$element->add_control(
				'sticky_parent',
				[
					'label' => __( 'Stay In Column', 'elementor-pro' ),
					'type' => Controls_Manager::SWITCHER,
					'condition' => [
						'sticky!' => '',
					],
					'render_type' => 'none',
					'frontend_available' => true,
				]
			);
		}

		if ( $this->is_prior_to_250 ) {
			$element->end_controls_section();
		}
	}

	private function add_actions() {
		if ( $this->is_prior_to_250 ) {
			add_action( 'elementor/element/section/section_advanced/after_section_end', [ $this, 'register_controls' ] );
			add_action( 'elementor/element/common/_section_style/after_section_end', [ $this, 'register_controls' ] );
		} else {
			add_action( 'elementor/element/section/section_effects/after_section_start', [ $this, 'register_controls' ] );
			add_action( 'elementor/element/common/section_effects/after_section_start', [ $this, 'register_controls' ] );
		}
	}
}
