<?php
/** no direct access **/
defined('MECEXEC') or die();

$reg_fields = $this->main->get_reg_fields();
?>
<?php do_action('mec_reg_form_start'); ?>
<div class="wns-be-container">

    <div id="wns-be-infobar">
        <a href="" id="" class="dpr-btn dpr-save-btn"><?php _e('Save Changes', 'modern-events-calendar-lite'); ?></a>
    </div>

    <div class="wns-be-sidebar">

        <ul class="wns-be-group-menu">

            <li class="wns-be-group-menu-li has-sub">
                <a href="<?php echo $this->main->remove_qs_var('tab'); ?>" id="" class="wns-be-group-tab-link-a">
                    <span class="extra-icon">
                        <i class="sl-arrow-down"></i>
                    </span>
                    <i class="mec-sl-settings"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Settings', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <?php if ($this->main->getPRO() and isset($this->settings['booking_status']) and $this->settings['booking_status']) : ?>
                <li class="wns-be-group-menu-li active">
                    <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-reg-form'); ?>" id="" class="wns-be-group-tab-link-a">
                        <i class="mec-sl-layers"></i>
                        <span class="wns-be-group-menu-title"><?php _e('Booking Form', 'modern-events-calendar-lite'); ?></span>
                    </a>
                </li>

                <li class="wns-be-group-menu-li">
                    <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-gateways'); ?>" id="" class="wns-be-group-tab-link-a">
                        <i class="mec-sl-wallet"></i>
                        <span class="wns-be-group-menu-title"><?php _e('Payment Gateways', 'modern-events-calendar-lite'); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-notifications'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-envelope"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Notifications', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-styling'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-equalizer"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Styling Options', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-customcss'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-wrench"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Custom CSS', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-messages'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-bubble"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Messages', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-ie'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-refresh"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Import / Export', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li>

            <!-- <li class="wns-be-group-menu-li">
                <a href="<?php echo $this->main->add_qs_var('tab', 'MEC-support'); ?>" id="" class="wns-be-group-tab-link-a">
                    <i class="mec-sl-support"></i>
                    <span class="wns-be-group-menu-title"><?php _e('Support', 'modern-events-calendar-lite'); ?></span>
                </a>
            </li> -->

        </ul>
    </div>

    <div class="wns-be-main">

        <div id="wns-be-notification"></div>

        <div id="wns-be-content">
            <div class="wns-be-group-tab">
                <h2><?php _e('Booking Form', 'modern-events-calendar-lite'); ?></h2>
                <div class="mec-container">
                    <?php do_action('before_mec_reg_fields_form'); ?>
                    <form id="mec_reg_fields_form">
                        <?php do_action('mec_reg_fields_form_start'); ?>
                        <div class="mec-form-row" id="mec_reg_form_container">                            
                            <?php /** Don't remove this hidden field **/ ?>
                            <input type="hidden" name="mec[reg_fields]" value="" />

                            <ul id="mec_reg_form_fields">
                                <?php
                                $i = 0;
                                foreach ($reg_fields as $key => $reg_field) {
                                    if (! is_numeric($key)) {
                                        continue;
                                    }
                                    $i = max($i, $key);

                                    if ($reg_field['type'] == 'text') {
                                        echo $this->main->field_text($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'email') {
                                        echo $this->main->field_email($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'tel') {
                                        echo $this->main->field_tel($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'textarea') {
                                        echo $this->main->field_textarea($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'p') {
                                        echo $this->main->field_p($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'checkbox') {
                                        echo $this->main->field_checkbox($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'radio') {
                                        echo $this->main->field_radio($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'select') {
                                        echo $this->main->field_select($key, $reg_field);
                                    } elseif ($reg_field['type'] == 'agreement') {
                                        echo $this->main->field_agreement($key, $reg_field);
                                    }
                                }
                                ?>
                            </ul>
                            <div id="mec_reg_form_field_types">
                                <button type="button" class="button" data-type="text"><?php _e('Text', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="email"><?php _e('Email', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="tel"><?php _e('Tel', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="textarea"><?php _e('Textarea', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="checkbox"><?php _e('Checkboxes', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="radio"><?php _e('Radio Buttons', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="select"><?php _e('Dropdown', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="agreement"><?php _e('Agreement', 'modern-events-calendar-lite'); ?></button>
                                <button type="button" class="button" data-type="p"><?php _e('Paragraph', 'modern-events-calendar-lite'); ?></button>
                            </div>
                            <?php do_action('mec_reg_fields_form_end'); ?>
                        </div>
                        <div class="mec-form-row">
                            <?php wp_nonce_field('mec_options_form'); ?>
                            <button  style="display: none;" id="mec_reg_fields_form_button" class="button button-primary mec-button-primary" type="submit"><?php _e('Save Changes', 'modern-events-calendar-lite'); ?></button>
                        </div>
                    </form>
                    <?php do_action('after_mec_reg_fields_form'); ?>
                </div>
                <input type="hidden" id="mec_new_reg_field_key" value="<?php echo $i + 1; ?>" />
                <div class="mec-util-hidden">
                    <div id="mec_reg_field_text">
                        <?php echo $this->main->field_text(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_email">
                        <?php echo $this->main->field_email(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_tel">
                        <?php echo $this->main->field_tel(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_textarea">
                        <?php echo $this->main->field_textarea(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_checkbox">
                        <?php echo $this->main->field_checkbox(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_radio">
                        <?php echo $this->main->field_radio(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_select">
                        <?php echo $this->main->field_select(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_agreement">
                        <?php echo $this->main->field_agreement(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_p">
                        <?php echo $this->main->field_p(':i:'); ?>
                    </div>
                    <div id="mec_reg_field_option">
                        <?php echo $this->main->field_option(':fi:', ':i:'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="wns-be-footer">
        <a href="" id="" class="dpr-btn dpr-save-btn"><?php _e('Save Changes', 'modern-events-calendar-lite'); ?></a>
    </div>

</div>

<script type="text/javascript">
jQuery(document).ready(function()
{
    jQuery(".dpr-save-btn").on('click', function(event)
    {
        event.preventDefault();
        jQuery("#mec_reg_fields_form_button").trigger('click');
    });
});

jQuery("#mec_reg_fields_form").on('submit', function(event)
{
    event.preventDefault();

    // Add loading Class to the button
    jQuery(".dpr-save-btn").addClass('loading').text("<?php echo esc_js(esc_attr__('Saved', 'modern-events-calendar-lite')); ?>");
    jQuery('<div class="wns-saved-settings"><?php echo esc_js(esc_attr__('Settings Saved!', 'modern-events-calendar-lite')); ?></div>').insertBefore('#wns-be-content');

    var fields = jQuery("#mec_reg_fields_form").serialize();
    jQuery.ajax(
    {
        type: "POST",
        url: ajaxurl,
        data: "action=mec_save_reg_form&"+fields,
        beforeSend: function () {
            jQuery('.wns-be-main').append('<div class="mec-loarder-wrap mec-settings-loader"><div class="mec-loarder"><div></div><div></div><div></div></div></div>');
        },
        success: function(data)
        {
            // Remove the loading Class to the button
            setTimeout(function(){
                jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js(esc_attr__('Save Changes', 'modern-events-calendar-lite')); ?>");
                jQuery('.wns-saved-settings').remove();
                jQuery('.mec-loarder-wrap').remove();
            }, 1000);
        },
        error: function(jqXHR, textStatus, errorThrown)
        {
            // Remove the loading Class to the button
            setTimeout(function(){
                jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js(esc_attr__('Save Changes', 'modern-events-calendar-lite')); ?>");
                jQuery('.wns-saved-settings').remove();
                jQuery('.mec-loarder-wrap').remove();
            }, 1000);
        }
    });
});
</script>
<?php do_action('mec_reg_form_end'); ?>
