<?php 
/* ===========================================================================
  ADD CUSTOM POST TYPES
  =========================================================================== */
include_once 'inc/faculty.php';


/* ===========================================================================
  REGISTER MENUS
  =========================================================================== */
register_nav_menus( array(
    'about_nav' => 'About Navigation',
    'classes_nav' => 'Classes Navigation',
    'concerts_nav' => 'Concerts Navigation',
    'contact_nav' => 'Contact Navigation',
    'alumni_nav' => 'Alumni Navigation'
) );


/* ===========================================================================
  LET POST THUMBNAILS BE
  =========================================================================== */
add_theme_support( 'post-thumbnails' ); 


/* ===========================================================================
  ENQUEUE SCRIPTS AND STYLES
  =========================================================================== */
function kokolita_scripts() {
  if (!is_admin()) {
    if(get_site_url() == 'http://kneisell.oakmaine.com')
      wp_enqueue_script( 'live', get_template_directory_uri() . '/js/live.js' );
    wp_enqueue_script( 'slick', get_template_directory_uri() . '/js/slick.js', array('jquery') );
    wp_enqueue_script( 'main', get_template_directory_uri() . '/js/main.js' );
    wp_register_style('main', get_template_directory_uri() . '/css/main.css', false, 1.0);
    wp_enqueue_style('main');
  }
}
add_action('wp_enqueue_scripts', 'kokolita_scripts');


/* ===========================================================================
  TRUNCATES CONTENT
  =========================================================================== */
function small_content($content, $legnth) {
  $content = strip_tags($content); // remove html
  $content = preg_replace("/\[[^)]+\]/", "", $content); // removes shortags and such
  $content = preg_replace('/\s+?(\S+)?$/', '', substr($content, 0, $legnth)) . '...'; // cuts our content off 
  return $content;
}

/* ===========================================================================
  CHANGES THE LOGIN LOGO
  =========================================================================== */
function my_login_logo() { ?>
    <style type="text/css">
        body.login {
            background-color: #fff;
        }
        body.login div#login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/img/logo.png);
            width: 288px;
            background-size: 100% auto;
            height: 78px;
        }
        .wp-core-ui .button-group.button-large .button, .wp-core-ui .button.button-large {
            background-color: #0a454d;
            border: 1px solid #0a454d;
            text-shadow:none;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );


/* ===========================================================================
  IMAGE FUNCTIONS
  =========================================================================== */



/* ===========================================================================
  MISC THEME AND TEMPLATE FUNCTIONS
  =========================================================================== */

// Move Yoast to bottom
function yoasttobottom() {
	return 'low';
}
add_filter( 'wpseo_metabox_prio', 'yoasttobottom');

function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['eps'] = 'application/postscript';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');



function get_oak_featured_image($id = false) {
    global $post;
    $id = ($id ? $id : $post->ID);
    $image = wp_get_attachment_image_src(get_post_thumbnail_id($id),'full');
    return $image[0];    
}


function kniesel_get_hero_image($id = false) {
    global $post;
    $id = ($id ? $id : $post->ID);
    if(get_field('header_image',$id)) {
        $image = get_field('header_image',$id);
        return $image['sizes']['full'];
    }
    else if($post->post_type=='faculty') {
        return '/wp-content/uploads/2018/12/kniesel-chamber-music-hall-header-1024x398.jpg';
    }
    else {
        return get_oak_featured_image($id);
    }
}

function kniesel_get_page_title($id) {
    $post = get_post($id);
    // if this is the about page overwrite the title to be history
    if($id == 64) {
        $title = 'Our History';
    }
    else {
        $title = $post->post_title;
    }
    return $title;
}

function kniesel_get_ins($field) {
    if($field) {        
        $i = 1;
        $output = '';
        $total = count($field);
        foreach($field as $ins) {
            $output .= $ins;
            if($i < $total) {$output .=', ';}
            $i++;
        }
        return $output;
    } else {
        return 'Other';
    }
}

function kneisel_get_teachings($field,$e = false) {
    $i = 1;
    $output = '';
    $total = count($field);
    if($total > 3) {
        return 'All programs';
    }
    foreach($field as $class) {
        if (strpos($class, 'Young') !== false && $e !== 1 ) {
            $output .= '<a href="'.get_permalink(53).'">'.$class.'</a>';
            $e = 1;
        } else {                            
            $output .= $class;
        }
        if($i < $total) {$output .=  ', ';}
        $i++;
    }  
    return $output;
}

add_filter( 'post_thumbnail_html', 'remove_width_attribute', 10 );
add_filter( 'image_send_to_editor', 'remove_width_attribute', 10 );

function remove_width_attribute( $html ) {
   $html = preg_replace( '/(width|height)="\d*"\s/', "", $html );
   return $html;
}

add_shortcode('wp_caption', 'fixed_img_caption_shortcode');
add_shortcode('caption', 'fixed_img_caption_shortcode');
function fixed_img_caption_shortcode($attr, $content = null) {
        // New-style shortcode with the caption inside the shortcode with the link and image tags.
        if ( ! isset( $attr['caption'] ) ) {
                if ( preg_match( '#((?:<a [^>]+>\s*)?<img [^>]+>(?:\s*</a>)?)(.*)#is', $content, $matches ) ) {
                        $content = $matches[1];
                        $attr['caption'] = trim( $matches[2] );
                }
        }

        // Allow plugins/themes to override the default caption template.
        $output = apply_filters('img_caption_shortcode', '', $attr, $content);
        if ( $output != '' )
                return $output;

        extract(shortcode_atts(array(
                'id'	  => '',
                'align'	  => 'alignnone',
                'width'	  => '',
                'caption' => ''
        ), $attr));

        if ( 1 > (int) $width || empty($caption) )
                return $content;

        if ( $id ) $id = 'id="' . esc_attr($id) . '" ';

        return '<div ' . $id . 'class="wp-caption ' . esc_attr($align) . '" style="width: auto">'
        . do_shortcode( $content ) . '<p class="wp-caption-text">' . $caption . '</p></div>';
}

add_action( 'template_redirect', 'redirect_to_specific_page' );

function redirect_to_specific_page() {
    if ( is_page(88) ) {
        wp_redirect( 'https://kneisel.org/programs/chamber-music-program/', 301 ); 
        exit;
    }
    if ( is_archive() ) {
        wp_redirect( 'https://kneisel.org/about/faculty/', 301 ); 
        exit;
    }
    if ( is_page(91) ) {
        wp_redirect( 'https://kneisel.org/calendar/all-events/', 301 ); 
        exit;
    }
}