<!doctype html>
<html class="no-js" lang="">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <title><?php wp_title();?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://fonts.googleapis.com/css?family=Lora:400,400i,700|Montserrat:500,500i,700" rel="stylesheet">
        <?php wp_head();?>
        <script id="mcjs">!function(c,h,i,m,p){m=c.createElement(h),p=c.getElementsByTagName(h)[0],m.async=1,m.src=i,p.parentNode.insertBefore(m,p)}(document,"script","https://chimpstatic.com/mcjs-connected/js/users/834ac866b393b091cfd31ab00/edf7bdcf0994d044bb298337f.js");</script>
    </head>
    <body <?php body_class();?>>
        <header>
            <a href="<?=site_url();?>" id="logo">
                <img src="<?=get_template_directory_uri();?>/img/white-logo.png" alt="Kneisel Music School" />
            </a>
            <nav>
                <div id="mobile-menu">Main Menu</div>
                <ul>
                    <li>
                        <a href="<?=get_permalink(64);?>">About</a>
                        <div class="mega">
                            <ul class="black-bg">
                                <?php wp_nav_menu(array(
                                    'theme_location' => 'header_nav',
                                    'container' => false,
                                    'items_wrap' => '%3$s',
                                )); ?>
                            </ul>
                            <div>
                                <h4><strong>Our History</strong></h4>
                                <p>In addition to being its namesake, Franz Kneisel’s passion for chamber music is the heart and soul of Kneisel Hall.</p>
                                <a href="<?=get_permalink(67);?>" class="square-link">Meet the faculty</a>
                            </div>
                        </div>
                    </li>
                    <li>
                        <a href="<?=get_permalink(53);?>">School</a>
                        <div class="mega classes">
                            <div class="black-bg">
                                <h4><strong>Kneisel Hall Chamber Music School</strong></h4>
                                <p>Kneisel Hall offers three distinct programs for music students, young professional artists, and adult life-long learners.</p>
                                <!--<div class="flex">
                                    <a href="<?=get_permalink(53);?>" class="square-link">Details</a>
                                    <!--<a href="https://app.getacceptd.com/kneisel" target="_blank">Apply for 2021</a>-->
                                    <!--<p style='font-size:1.2rem'>2019 app closed.</p>-->
                                <!--</div>-->
                            </div>
                            <ul>
                                <li><strong>Explore our programs:</strong></li>
                                <?php wp_nav_menu(array(
                                    'theme_location' => 'classes_nav',
                                    'container' => false,
                                    'items_wrap' => '%3$s',
                                )); ?>
                            </ul>
                        </div>
                    </li>
                 <li>
                        <a href="/2021season">Concerts</a>
                        <div class="mega concerts">
                            <div>
                                <h4><strong>Kneisel Hall in New York: Benefit Concert Celebrating Ellen Werner</strong></h4>                                
            					<p>Join us for a benefit concert celebrating Ellen Werner and her remarkable 25-year tenure as Executive Director, on March 12, 2022. Save the dates for 2022 Festival: July 1 - August 28! Weekly concerts on Fridays and Sundays. Tickets go on sale later this spring.</p>
                                <a href="/ellenwerner" class="square-link">Learn More</a>
                            </div>
                            <!--<ul class="black-bg">
                                <?php wp_nav_menu(array(
                                    'theme_location' => 'concerts_nav',
                                    'container' => false,
                                    'items_wrap' => '%3$s',
                                )); ?>
                            </ul>-->
                        </div>
                    </li>
                    <li>                        <a href="<?=get_permalink(72);?>">Contact</a>
                        <div class="mega contact">
                            <div>
                                <h4><strong>Donate to Kneisel</strong></h4>
                                <p>Your donation supports our musicians and the music they make.</p>
                                <a href="<?=get_permalink(793);?>" class="square-link">Donate</a>
                            </div>
                            <ul class="black-bg">
                                <?php wp_nav_menu(array(
                                    'theme_location' => 'contact_nav',
                                    'container' => false,
                                    'items_wrap' => '%3$s',
                                )); ?>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <a href="https://app.getacceptd.com/kneisel" target="_blank">
                            Apply
                        </a>
                    </li>
                </ul>  
            </nav>
        </header>