<?php

/* ===========================================================================
  BIO POST TYPE
  =========================================================================== */
add_action('init', 'register_cpt_faculty');

function register_cpt_faculty() {
  $cptname = 'faculty';
  $navName = 'Faculty';
  $singleName = 'Faculty';
  $pluralName = 'Faculty';
  $labels = array(
      'name' => _x($pluralName, $cptname),
      'singular_name' => _x($singleName, $cptname),
      'add_new' => _x('Add New '.$singleName, $cptname),
      'add_new_item' => _x('Add New '.$singleName, $cptname),
      'edit_item' => _x('Edit '.$singleName, $cptname),
      'new_item' => _x('New '.$singleName, $cptname),
      'view_item' => _x('View '.$singleName, $cptname),
      'search_items' => _x('Search '.$pluralName, $cptname),
      'not_found' => _x('No '.$pluralName.' found', $cptname),
      'not_found_in_trash' => _x('No '.$pluralName.' found in Trash', $cptname),
      'parent_item_colon' => _x('Parent '.$singleName.':', $cptname),
      'menu_name' => _x($navName, $cptname),
  );
  $args = array(
      'labels' => $labels,
      'hierarchical' => false,
      'supports' => array('title', 'revisions','editor','thumbnail'),
      'public' => true,
      'show_ui' => true,
      'show_in_menu' => true,
      'show_in_nav_menus' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => true,
      'has_archive' => true,
      'query_var' => false,
      'can_export' => true,
      'rewrite' => array( 'slug' => 'kniesel-faculty','with_front' => true),
      'capability_type' => 'page',        
      'menu_icon' => 'dashicons-businessman'
  );  

  register_post_type($cptname, $args);
}
