<?php

/*
 * Template Name: Faculty
 */

get_header();
$fields = get_fields();
while ( have_posts() ) : the_post();?>
<?php get_template_part('parts/hero');?>
<main>
    <section class="container padding-bottom">
        <?php 
        $args = array(
            'posts_per_page'   => 999,
            'meta_key'	       => 'instrument',
            'orderby'          => 'meta_value',
            'order'            => 'DESC',
            'post_type'        => 'faculty',
            'post_status'      => 'publish',
        );
        $faculty = get_posts( $args );
        ?>
        <div class="search">
            
        </div>
        <ul class="section-links">
            <li class="active" data-tab="faculty"><span>2021 Faculty</span></li>
            <!--<li data-tab="guests"><span>2021 Guests</span></li>-->
        </ul>
        <div class="section-item" id="faculty">
          <div class="director flex">
              <a href="<?=get_permalink(221);?>">
                  <img src="/wp-content/uploads/2018/12/laurie-smulker-kneisel-chamber-music-thumbnail.jpg" />
              </a>
              <div class="content">
                  <h2>
                      Laurie Smukler
                      <span>Artistic director & violin</span>
                  </h2>
                  <p>Admired for her vivid musical intensity and the beauty of her sound, violinist and artistic director, she is an artist who is active as soloist, recitalist and chamber musician.</p> 
                  <a href="<?=get_permalink(221);?>" class="square-link">Learn more about Laurie</a>
              </div>
          </div>
          <div class="faculty-roll">
              <?php foreach($faculty as $person):
                $fields = get_fields($person->ID);
                if($fields['position'] !== 'Guest'):
                  $thumb = get_oak_featured_image($person->ID)?>
                  <a href="<?=get_permalink($person->ID);?>" class="person">
                      <span class="image">
                          <img src="<?=$thumb;?>" />
                      </span>
                      <span class="title">
                          <h4><?=$person->post_title;?></h4>
                          <em><?=$fields['school'];?></em>
                      </span>
                      <span class="ins">
                          <em><?=kniesel_get_ins($fields['instrument']);?></em>
                      </span>
                      <span class="pos">
                          <em><?=$fields['position'];?></em>
                          <span><?=kneisel_get_teachings($fields['teaching'],1);?></span>
                      </span>
                      <span class="more">
                          read more
                      </span>
                  </a>
                <?php endif;
              endforeach;?>
          </div>
        </div>
        <div class="faculty-roll section-item hide" id="guests">
            <?php foreach($faculty as $person):
              $fields = get_fields($person->ID);
              if($fields['position'] == 'Guest'):
                $thumb = get_oak_featured_image($person->ID)?>
                <a href="<?=get_permalink($person->ID);?>" class="person">
                    <span class="image">
                        <img src="<?=$thumb;?>" />
                    </span>
                    <span class="title">
                        <h4><?=$person->post_title;?></h4>
                        <em><?=$fields['school'];?></em>
                    </span>
                    <span class="ins">
                        <em><?=kniesel_get_ins($fields['instrument']);?></em>
                    </span>
                    <span class="pos">
                        <em><?=$fields['position'];?></em>
                    </span>
                    <span class="more">
                        read more
                    </span>
                </a>
              <?php endif;
            endforeach;?>
        </div>
        
    </section>
</main>

<?php endwhile;



get_footer();
?>